% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cumMax.R
\name{cumMax}
\alias{cumMax}
\title{Computes the maximum of the vector up to the current index}
\usage{
cumMax(x)
}
\arguments{
\item{x}{A numeric or integer vector}
}
\value{
In the sequence \emph{x[1], x[2], ..., x[n]}, \code{cumMax}
returns the vector \emph{y} such that for each \emph{i = 1,...,n},
\emph{y[i] = max(x[j]; j = 1,...,i)}
}
\description{
For each index in a vector, computes the maximum of the vector from the
beginning of the vector up to the current index
}
\examples{
cumMax(1:10)
cumMax(c(1,3,4,5,3,2,5,1,7,8,8,6))
cumMax(c(1,3,4,5,3,2,5,1,7,8,8,6) + runif(12))
}
\author{
Landon Sego
}
\keyword{misc}

