% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFun.R
\name{plotFun}
\alias{plotFun}
\title{Plot one or more functions on a single plot}
\usage{
plotFun(fun, xlim, col = rainbow(length(fun)), lty = 1:length(fun),
  type = "l", legendLabels = NULL, relX = 0.7, relY = 0.9,
  nPoints = 1000, njobs = 1, ...)
}
\arguments{
\item{fun}{A function or a list of functions to be plotted.  These functions should take a single, numeric vector argument and return
a corresponding vector of outputs.}

\item{xlim}{A numeric vector with two elements that define the domain over which the function(s) will be evaluated
and plotted, just as in \code{\link{plot.default}} in the \pkg{graphics} package.}

\item{col}{A vector of colors to use in the plotting. It's length should match the length of \code{fun}. See \code{\link{par}} for
more info about the \code{col} graphics parameter.}

\item{lty}{A vector of line types to use in the plotting. It's length should match the length of \code{fun}. See \code{\link{par}} for
more info about the \code{lty} graphics parameter.}

\item{type}{A single character indicating the type of plotting. This is passed to the \code{type} argument of
\code{\link{plot.default}}.}

\item{legendLabels}{A character vector with descriptive names that will appear in the legend, corresponding to each function
If \code{NULL}, no legend is drawn. This character vector is passed to the \code{legend} argument in \code{\link{legend}}
from the \pkg{graphics} package.}

\item{relX}{A numeric value in [0, 1] designating the relative horizontal (x) position of the legend in the plot.}

\item{relY}{A numeric value in [0, 1] designating the relative vertical (y) position of the legend in the plot.}

\item{nPoints}{The number of points that are evaluated and plotted for each function over the interval given by \code{xlim}.}

\item{njobs}{The number of parallel jobs to spawn using \code{\link{doCallParallel}}.}

\item{\dots}{Additional graphical arguments passed to \code{\link{plot.default}}, \code{\link{lines}}, and
\code{\link{legend}}.  If an argument name specified in \code{\dots} matches an argument name in any
of these three functions, the argument is passed to that function.
For example, the line width, \code{lwd}, would be passed to all three (\code{\link{plot.default}}, \code{\link{lines}}, and
\code{\link{legend}}).}
}
\value{
The plot of the function(s)
}
\description{
A convenient wrapper function for plotting one or more functions on a single plot. If the function(s) is/are expensive to 
calculate, function values can be calculated in parallel.
}
\examples{
# A single function with a single argument
f <- function(x) x^2
plotFun(f, c(-2, 3), col = "Black", lty = 2, las = 1)

# A handful of beta density functions, note how they take a single argument
fList <- list(function(x) dbeta(x, 10, 10),
              function(y) dbeta(y, 3, 3),
              function(z) dbeta(z, 0.5, 0.50))

# Plot them all on the same plot
plotFun(fList, c(0.0001, 0.9999), ylim = c(0, 3.5),
        col = c("Red", "Black", "Blue"), lty = rep(1, 3),
        xlab = "x", ylab = expression(f(x)),
        legendLabels = c("a = 10, b = 10", "a = 3, b = 3", "a = 0.5, b = 0.5"),
        relX = 0.6, relY = 1, lwd = 3, main = "Gamma Densities")
}
\author{
Landon Sego
}

