% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SmCCNet-source.R
\name{dataPreprocess}
\alias{dataPreprocess}
\title{preprocess a omics dataset before running omics SmCCNet}
\usage{
dataPreprocess(
  X,
  covariates = NULL,
  is_cv = FALSE,
  cv_quantile = 0,
  center = TRUE,
  scale = TRUE
)
}
\arguments{
\item{X}{dataframe with the size of \eqn{n} by \eqn{p}, where \eqn{n} is the sample size and \eqn{p} is the feature size.}

\item{covariates}{dataframe with covariates to be adjusted for.}

\item{is_cv}{Whether to use coefficient of variation filter (small cv filter out).}

\item{cv_quantile}{CV filtering quantile.}

\item{center}{Whether to center the dataset X.}

\item{scale}{Whether to scale the dataset X.}
}
\value{
Processed omics data with the size of nxp.
}
\description{
Data preprocess pipeline to: (1) filter by coefficient of variation (cv), (2) center or scale data
and (3) adjust for clinical covariates.
}
\examples{

X1 <- as.data.frame(matrix(rnorm(600, 0, 1), nrow = 60))
covar <- as.data.frame(matrix(rnorm(120, 0, 1), nrow = 60))
processed_data <- dataPreprocess(X = X1, covariates = covar, is_cv = TRUE, 
cv_quantile = 0.5, center = TRUE, scale = TRUE)

}
