\name{getPolygon}
\alias{getPolygon}
\title{Get the boundary box for a given dataset retrieved in a query}
\description{
\code{getPolygon} creates an SpatialPolygonsDataFrame object that displays the boundary box for a given dataset based on info from the *area* column in the data.frame generated by \code{querySW}.
}
\usage{
getPolygon(x, index)
}
\arguments{
  \item{x}{
data.frame returned by the querySW function
}
  \item{index}{
numeric; index (row) of a record in \code{x}. See Details section
}
}
\details{
\code{getPolygon} creates an SpatialPolygonsDataFrame object that displays the boundary box for a given dataset (corresponding to row \code{index}) based on info from the *area* column in the data.frame generated by \code{querySW}.
}
\value{
a SpatialPolygonsDataFrame object
}
\examples{
\dontrun{
api_key <- "your_personal_alphanumeric_api_key"

# Set the SkyWatchr.apikey option 
options(SkyWatchr.apikey = api_key)

res <- querySW(time_period = "2015-8", longitude_latitude = "-71.1043443,-42.3150676")
sppolygon <- getPolygon(res, 55)

library(mapview)
mapView(sppolygon)
}
}
\keyword{ spatial }% use one of  RShowDoc("KEYWORDS")