% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qcr.profiles.R
\name{smoothProfiles}
\alias{smoothProfiles}
\title{Regularise set of profiles}
\usage{
smoothProfiles(profiles, x = 1:nrow(profiles), svm.c = NULL,
  svm.eps = NULL, svm.gamma = NULL, parsvm.unique = TRUE)
}
\arguments{
\item{profiles}{Matrix of y values, one column per profile}

\item{x}{Vector of predictive variable values, common to all profiles}

\item{svm.c}{SVM parameter (cost)}

\item{svm.eps}{SVM parameter (epsilon)}

\item{svm.gamma}{SVM parameter (gamma)}

\item{parsvm.unique}{Same parameters for all profiles? (logical [TRUE])}
}
\value{
Regularized profiles
}
\description{
This function takes a set of profiles and regularise them by means of a SVM
}
\note{
The package \code{e1071} is needed in order to be able to use this function. SVM Parameters can be vectors of the same lenght as number of profiles, or a single value for all of them
}
\examples{
wby.smooth <- smoothProfiles(profiles = ss.data.wby,
    x = ss.data.wbx)
plotProfiles(profiles = wby.smooth,
    x = ss.data.wbx)     
}
\references{
Cano, E.L. and Moguerza, J.M. and Prieto Corcoba, M. (2015)
\emph{Quality Control with R. An ISO Standards Approach}. Springer.
}
\author{
Javier M. Moguerza and Emilio L. Cano
}
