% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_radii_results.R
\name{plot_radii_results}
\alias{plot_radii_results}
\title{Plots the results from using different radii}
\usage{
plot_radii_results(Name, Radii, first = 'n', legend_loc = "topright")
}
\arguments{
\item{Name}{name of the data, which is used for any saved files and plot titles}

\item{Radii}{set of radius values}

\item{first}{if \code{'y'}, the algorithm will look for the second greatest maximum percent drop if the first results in the first circle being the only non-identified site}

\item{legend_loc}{location of the legend}
}
\value{
Plot of results from various radius values
}
\description{
Plots the results (maximum percent drop and number of identified sites) from already calculated residence times for different radii values.
}
\details{
After finding the residence times for various radii values using \code{\link{Alt_Alg}}, this function plots the number of identified sites of interest and their corresponding maximum percent drops for each radii value. This plot could be used to identify which radius value to use.
}
\examples{
\donttest{##Find the current working directory
wd = getwd()
##Set the working directory as the temporary one
setwd(tempdir())
##Load the data
data(OU_14)
t=unlist(OU_14["t"])
X=unlist(OU_14["X"])
Y=unlist(OU_14["Y"])

##Run the algorithm for multiple radii values
Radii=seq(0.2,1.0,0.1)
for (R in Radii){
  Alt_Alg("OU_14",t,X,Y,R,first='y',save='y')}

##Plot the results (i.e. maximum percent drop and number of sites identified) from applying
##the algorithm with various radius values
plot_radii_results("OU_14",Radii,first='y')

##The location of the legend can be changed
plot_radii_results("OU_14",Radii,first='y', legend_loc="bottomleft")

##Reset the original working directory
setwd(wd)}
}
\references{
Munden, R., Borger , L., Wilson, R.P., Redcliffe, J., Loison, A., Garel, M. and Potts, J.P. in review. Making sense of ultra-high-resolution movement data: an algorithm for inferring sites of interest.
}
\seealso{
See also \code{\link{Alt_Alg}} to find the residence times. \code{\link{Sites}} can be used to find the number of identified sites of interest and corresponding maximum percent drop from the csv files produced by \code{\link{Alt_Alg}}.
}
\author{
Rhys Munden <rdmunden1@sheffield.ac.uk>
}
\keyword{Plots}
