% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Alt_Alg_mini.R
\name{Alt_Alg_mini}
\alias{Alt_Alg_mini}
\title{Calculates the residence times for circles taken from one trajectory, but applied to another}
\usage{
Alt_Alg_mini(Circles_name, t_centers, X_centers, Y_centers, Path_name, t, X, Y, R, 
s = 10, m = 500, save = 'n')
}
\arguments{
\item{Circles_name}{name of the trajectory used to find the circles}

\item{t_centers}{array of times when the positions were recorded}

\item{X_centers}{array of the x-coordinates of the circles' centres}

\item{Y_centers}{array of the y-coordinates of the circles' centres}

\item{Path_name}{name of the trajectory that the residence times are found from}

\item{t}{array of the times that the positions are recorded at}

\item{X}{array of the x-coordinates describing the trajectory}

\item{Y}{array of the y-coordinates describing the trajectory}

\item{R}{radius value to use}

\item{s}{number of time steps between checks for entrances and exits}

\item{m}{estimate of the maximum number of crossings across all circles}

\item{save}{if \code{'y'}, save the files}
}
\description{
The circles found from applying \code{\link{Alt_Alg}} to one trajectory are used to find the residence times of another trajectory passing through these circles.
}
\details{
This functions works in a similar way to \code{\link{Alt_Alg}}, but the circles are found from one trajectory and are applied to another. The results are stored in a csv file `\emph{Circles_name}'_multi_`\emph{Path_name}'_UD_alt_R`\emph{R}'.csv and the crossing times are stored in `\emph{Circles_name}'_multi_`\emph{Path_name}'_M_alt_R`\emph{R}'.csv
}
\examples{
##Find the current working directory
wd = getwd()
##Set the working directory as the temporary one
setwd(tempdir())
##Load the data
data(OU_14)
t=unlist(OU_14["t"])
X=unlist(OU_14["X"])
Y=unlist(OU_14["Y"])

##Number of path sections
n=5
##Number of recorded locations
N = length(t)

##A list of arrays of the time recoding for the 3 of the path segments
t_all = list(t[seq(1,floor(N/n))], t[seq(floor(N/n)*2,floor(N/n)*3)], 
t[seq(floor(N/n)*4,floor(N/n)*5)])

##A list of arrays of the x-coordinates for the 3 of the path segments
X_all = list(X[seq(1,floor(N/n))], X[seq(floor(N/n)*2,floor(N/n)*3)], 
X[seq(floor(N/n)*4,floor(N/n)*5)])

##A list of arrays of the y-coordinates for the 3 of the path segments
Y_all = list(Y[seq(1,floor(N/n))], Y[seq(floor(N/n)*2,floor(N/n)*3)], 
Y[seq(floor(N/n)*4,floor(N/n)*5)])

##Calculates the residence time for one particular path segment
Alt_Alg("OU_14.1",unlist(t_all[1]),unlist(X_all[1]),unlist(Y_all[1]),0.3,first='y',save='y')

##Load the data of the circles found from Alt_Alg
df = read.csv(paste("OU_14.1","_UD_alt_R",0.3,".csv",sep=''))
t_centers = unlist(df[1])
X_centers = unlist(df[2])
Y_centers = unlist(df[3])

##Calculates the residence time from path segment 3, using circles from path segment 1
Alt_Alg_mini("OU14.1", t_centers, X_centers, Y_centers, "OU_14.3", unlist(t_all[2]), 
unlist(X_all[2]), unlist(Y_all[2]), 0.3,save='y')

##Reset the original working directory
setwd(wd)
}
\references{
Munden, R., Borger , L., Wilson, R.P., Redcliffe, J., Loison, A., Garel, M. and Potts, J.P. in review. Making sense of ultra-high-resolution movement data: an algorithm for inferring sites of interest.
}
\seealso{
See also \code{\link{Alt_Alg}} for how to apply the algorithm to continuous data. \code{\link{Alt_Alg_discont}} perform \code{\link{Alt_Alg_mini}} on all trjectories, then \code{\link{combining}} combines the results from each application of \code{\link{Alt_Alg_mini}}.
}
\author{
Rhys Munden <rdmunden1@sheffield.ac.uk>
}
\keyword{Discontinuous}
