% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_process.R
\name{adapt_process}
\alias{adapt_process}
\title{Site adaptation of solar irradiance modeled series with coincident ground measurements}
\usage{
adapt_process(
  subset_target_period,
  latitude_target,
  z_target,
  subset_calibrating_period,
  latitude_calibrat,
  z_calibrat,
  GHI_threshold,
  DNI_threshold
)
}
\arguments{
\item{subset_target_period}{Dataframe object with solar radiation series to be adapted including time (with same time zone as subset_calibrating_period), the solar irradiance modeled series to be site adapted, along with their clear sky index and solar elevation (degrees)}

\item{latitude_target}{Site latitude of solar radiation series to be adapted (degrees, +N)}

\item{z_target}{Site elevation above sea level of solar radiation series to be adapted (m)}

\item{subset_calibrating_period}{Dataframe object with solar radiation series for calibrating including time (with same time zone as subset_target_period), solar irradiance modeled and measured series, along with modeled clear sky index and solar elevation (degrees)}

\item{latitude_calibrat}{Site latitude of solar radiation series for calibrating (degrees, +N)}

\item{z_calibrat}{Site elevation above sea level of solar radiation series for calibrating (m)}

\item{GHI_threshold}{Upper limit of GHI series (same units that Target). For automatic calulation from observed data, set it to -99}

\item{DNI_threshold}{Upper limit of DNI series (same units that Target). For automatic calulation from observed data, set it to -99}
}
\value{
Dataframe object including time and site adapted solar irradiance series
}
\description{
Site adaptation of solar irradiance modeled series with coincident ground measurements
}
\references{
Fernández-Peruchena, C.M.; Polo, J.; Martín, L.; Mazorra, L. Site-Adaptation of Modeled Solar Radiation Data: The SiteAdapt Procedure. Remote Sens. 2020, 12, 2127.
}
