% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{uniroot.integer.mod}
\alias{uniroot.integer.mod}
\title{Optimizer for Uniroot Integer (Modified)}
\usage{
uniroot.integer.mod(
  f,
  power,
  lower = lower,
  upper = upper,
  step.power = step.power,
  step.up = step.up,
  pos.side = pos.side,
  maxiter = maxiter,
  ...
)
}
\arguments{
\item{f}{Function for which a root is needed.}

\item{power}{Numeric. Target power value.}

\item{lower}{Integer. Minimum allowable root value.}

\item{upper}{Integer. Maximum allowable root value.}

\item{step.power}{Numeric. Initial step size defined as \code{2^step.power}.}

\item{step.up}{Logical. If \code{TRUE}, the search increments from \code{lower}; if \code{FALSE}, it decrements from \code{upper}.}

\item{pos.side}{Logical. If \code{TRUE}, finds the closest integer \code{i} such that \code{f(i) > 0}.}

\item{maxiter}{Integer. Maximum number of iterations allowed.}

\item{...}{Additional arguments passed to \code{f}.}
}
\value{
A list containing:
\describe{
\item{\code{root}}{The integer value closest to the root on the correct side.}
\item{\code{f.root}}{Value of \code{f} at the estimated root.}
\item{\code{iter}}{Number of function evaluations performed.}
\item{\code{table.iter}}{A data frame showing estimated sample size (\code{N}) and corresponding power at each iteration.}
\item{\code{table.test}}{A data frame containing endpoint-level test results for each simulation and corresponding \code{N}.}
}
}
\description{
A modified integer-based root-finding algorithm for determining the sample size required to achieve a target power.
This function extends the uniroot integer search method to handle cases with stepwise power searches while considering constraints on search limits.
}
\keyword{internal}
