% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_survey.R
\name{sim_survey}
\alias{sim_survey}
\title{Simulate stratified-random survey}
\usage{
sim_survey(
  sim,
  n_sims = 1,
  q = sim_logistic(),
  trawl_dim = c(1.5, 0.02),
  resample_cells = FALSE,
  binom_error = TRUE,
  min_sets = 2,
  set_den = 2/1000,
  lengths_cap = 500,
  ages_cap = 10,
  age_sampling = "stratified",
  age_length_group = 1,
  age_space_group = "division",
  custom_sets = NULL,
  light = TRUE
)
}
\arguments{
\item{sim}{A simulation object returned by \code{\link[=sim_distribution]{sim_distribution()}}.}

\item{n_sims}{Number of surveys to simulate.
Be cautious: large values may consume significant memory. Use \code{\link[=sim_survey_parallel]{sim_survey_parallel()}} if many simulations are needed.}

\item{q}{A closure (e.g., \code{\link[=sim_logistic]{sim_logistic()}}) for simulating catchability at age.
Returned values must range between 0 and 1.}

\item{trawl_dim}{Trawl width and distance (same units as the grid).}

\item{resample_cells}{Logical. If \code{TRUE}, allows grid cells to be resampled.
May introduce bias, as depletion is applied at the cell level.}

\item{binom_error}{Logical. Should binomial error be imposed?
If \code{FALSE}, stratified estimates at older ages may be biased due to rounding zeros.}

\item{min_sets}{Minimum number of sets per stratum.}

\item{set_den}{Set density (sets per grid unit squared).
\strong{Warning:} May error if \code{set_den} is high and \code{resample_cells = FALSE}, because allocated sets may exceed available cells.}

\item{lengths_cap}{Maximum number of lengths measured per set.}

\item{ages_cap}{Cap on the number of ages to sample, depending on \code{age_sampling} type:
\itemize{
\item If \code{"stratified"}: maximum per length bin (via \code{age_length_group}) and per \code{age_space_group} (e.g., \code{"division"}, \code{"strat"}).
\item If \code{"random"}: maximum number of fish aged per set.
}}

\item{age_sampling}{Type of age sampling strategy: \code{"stratified"} (default) or \code{"random"}.}

\item{age_length_group}{Width of length bins for stratified age sampling. Ignored if \code{age_sampling = "random"}.}

\item{age_space_group}{Spatial scale for stratified age sampling.
Options: \code{"division"} (default), \code{"strat"}, or \code{"set"}. Ignored if \code{age_sampling = "random"}.}

\item{custom_sets}{A \code{data.table} of set locations (same structure as returned by \code{\link[=sim_sets]{sim_sets()}}).
If \code{NULL}, set locations are generated automatically.}

\item{light}{Logical. If \code{TRUE}, drops some objects from output to reduce memory footprint.}
}
\value{
A list including:
\itemize{
\item Rounded simulation results
\item Set location details
\item Sampling results
}

Includes:
\itemize{
\item \code{N}: true population
\item \code{I}: individuals available to the survey
\item \code{n}: individuals caught by the survey
}
}
\description{
Simulates a stratified-random survey on a population produced by \code{\link[=sim_distribution]{sim_distribution()}}.
Supports optional catchability functions, sampling caps, and custom set locations.
}
\examples{
\donttest{
sim <- sim_abundance(ages = 1:5, years = 1:5) |>
  sim_distribution(grid = make_grid(res = c(20, 20))) |>
  sim_survey(n_sims = 5, q = sim_logistic(k = 2, x0 = 3))

plot_survey(sim, which_year = 3, which_sim = 1)
}

}
