% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_dist.R
\name{sim_ays_covar}
\alias{sim_ays_covar}
\title{Simulate age-year-space covariance}
\usage{
sim_ays_covar(
  sd = 2.8,
  range = 300,
  lambda = 1,
  model = "matern",
  phi_age = 0.5,
  phi_year = 0.9,
  group_ages = 5:20,
  group_years = NULL
)
}
\arguments{
\item{sd}{Variance (can be age specific).}

\item{range}{Decorrelation range}

\item{lambda}{Controls the degree of smoothness of Matern covariance process}

\item{model}{String indicating either "exponential" or "matern" as the correlation function}

\item{phi_age}{Defines autocorrelation through ages. Can be one value or a vector of the same
length as ages}

\item{phi_year}{Defines autocorrelation through years. Can be one value or a vector of the same
length as years}

\item{group_ages}{Make space-age-year noise equal across these ages}

\item{group_years}{Make space-age-year noise equal across these years}
}
\description{
These functions return a function to use inside \code{\link{sim_distribution}}.
}
