% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_seqFunctions.R
\name{reconstruct_fromHaplotype}
\alias{reconstruct_fromHaplotype}
\title{Construct offspring sequence from parental allele vector}
\usage{
reconstruct_fromHaplotype(parental_genotypes, CSNV_map,
  inherited_haplotype, chiasmata_locations, REDchrom_map)
}
\arguments{
\item{parental_genotypes}{The parental genotype sequence information.}

\item{CSNV_map}{Data.frame. Must contain three columns with: column 1: marker names, must be listed in the same order as in the founder genotype file, column 2: the chromosome that the marker resides on, column 3: the position of the marker in cM.}

\item{inherited_haplotype}{The coded haplotype sequence, which indiciates the haplotype that the data will come from.}

\item{chiasmata_locations}{A list of crossover locations.}

\item{REDchrom_map}{Data.frame.  The chromosome map, reduced to the chromosome in question.}
}
\value{
offspring_seq. The genetic data that the offspring inherits from this parent.  This will be a recombined sequence.
}
\description{
For internal use.
}
\details{
Prior to running this function, for each chromosome, we have a coded sequence (i.e. c(1, 2, 1)) and a list of crossover points (i.e. c(45, 100)). This data would indicate that the offspring inherts all genetic data from the start postion to postion 45 of the parent's 1st haplotype, then all genetic data after position 45 up to postion 100 from the 2nd haplotype, and all genetic data after postion 100 from the 1st haplotype.  This function completes that task.
}
\keyword{internal}
