% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RVPedSim_Functions.R
\name{choose_proband}
\alias{choose_proband}
\title{Choose a proband from the disease-affected relatives in a pedigree}
\usage{
choose_proband(ped_file, num_affected, ascertain_span, first_diagnosis)
}
\arguments{
\item{ped_file}{Pedigree simulated by \code{sim_ped}.}

\item{num_affected}{Numeric.  The minimum number of affected individuals in the pedigree.}

\item{ascertain_span}{Numeric vector of length 2.  The year span of the ascertainment period.  This period represents the range of years during which the proband developed disease and the family would have been ascertained for multiple affected relatives.}

\item{first_diagnosis}{Numeric. The first year that reliable diagnoses can be obtained regarding disease-affection status.  By default, \code{first_diagnosis}\code{ = NULL} so that all diagnoses are considered reliable. See details.}
}
\value{
Pedigree with proband selected.
}
\description{
Choose a proband from the disease-affected relatives in a pedigree
}
\keyword{internal}
