% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise.R
\name{summarise_test}
\alias{summarise_test}
\title{Generic summarise function for tests}
\usage{
summarise_test(alpha, name = NULL)
}
\arguments{
\item{alpha}{the significance level(s)}

\item{name}{name for the summarise function,
appended to the name of the analysis method in the final results}
}
\value{
A function that can be used in Summarise that returns a data frame with the columns
\itemize{
\item rejection_X
\item rejection_Y
\item ...
}

Where X, Y, ... are the alpha levels given in the argument
}
\description{
Generic summarise function for tests
}
\examples{
\donttest{
condition <- merge(
  assumptions_delayed_effect(),
  design_fixed_followup(),
  by=NULL
) |>
  tail(4) |>
  head(1)

summarise_all <- create_summarise_function(
  logrank=summarise_test(alpha=c(0.5, 0.9, 0.95, 0.99))
)

# runs simulations
sim_results <- runSimulation(
  design=condition,
  replications=100,
  generate=generate_delayed_effect,
  analyse=list(
    logrank=analyse_logrank()
  ),
  summarise = summarise_all
)

sim_results[, grepl("rejection", names(sim_results))]
}
}
