% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findintercorr_nb.R
\name{findintercorr_nb}
\alias{findintercorr_nb}
\title{Calculate Intermediate MVN Correlation for Negative Binomial Variables: Method 1}
\usage{
findintercorr_nb(rho_nb, size, prob, mu = NULL, nrand = 100000,
  seed = 1234)
}
\arguments{
\item{rho_nb}{a \code{k_nb x k_nb} matrix of target correlations}

\item{size}{a vector of size parameters for the Negative Binomial variables (see \code{\link[stats]{dnbinom}})}

\item{prob}{a vector of success probability parameters}

\item{mu}{a vector of mean parameters (*Note: either \code{prob} or \code{mu} should be supplied for all Negative Binomial variables,
not a mixture; default = NULL)}

\item{nrand}{the number of random numbers to generate in calculating the bound (default = 10000)}

\item{seed}{the seed used in random number generation (default = 1234)}
}
\value{
the \code{k_nb x k_nb} intermediate correlation matrix for the Negative Binomial variables
}
\description{
This function calculates a \code{k_nb x k_nb} intermediate matrix of correlations for the Negative Binomial variables by
    extending the method of Yahav & Shmueli (2012, \doi{10.1002/asmb.901}). The intermediate correlation between Z1 and Z2 (the
    standard normal variables used to generate the Negative Binomial variables Y1 and Y2 via the inverse cdf method) is
    calculated using a logarithmic transformation of the target correlation.  First, the upper and lower Frechet-Hoeffding bounds
    (mincor, maxcor) on \eqn{\rho_{y1,y2}} are simulated.  Then the intermediate correlation is found as follows:
    \deqn{\rho_{z1,z2} = (1/b) * log((\rho_{y1,y2} - c)/a)}, where \eqn{a = -(maxcor * mincor)/(maxcor + mincor)},
    \eqn{b = log((maxcor + a)/a)}, and \eqn{c = -a}.  The function adapts code from Amatya & Demirtas' (2016) package
    \code{\link[PoisNor]{PoisNor}} by:

    1) allowing specifications for the number of random variates and the seed for reproducibility

    2) providing the following checks: if \eqn{\rho_{z1,z2}} >= 1, \eqn{\rho_{z1,z2}} is set to 0.99; if \eqn{\rho_{z1,z2}} <= -1,
    \eqn{\rho_{z1,z2}} is set to -0.99

    3) simulating Negative Binomial variables.

    The function is used in \code{\link[SimMultiCorrData]{findintercorr}} and \code{\link[SimMultiCorrData]{rcorrvar}}.
    This function would not ordinarily be called by the user.
}
\references{
Please see references for \code{\link[SimMultiCorrData]{findintercorr_pois}}.
}
\seealso{
\code{\link[PoisNor]{PoisNor}}, \code{\link[SimMultiCorrData]{findintercorr_pois}},
    \code{\link[SimMultiCorrData]{findintercorr_pois_nb}},
    \code{\link[SimMultiCorrData]{findintercorr}}, \code{\link[SimMultiCorrData]{rcorrvar}}
}
\keyword{1}
\keyword{Binomial,}
\keyword{Negative}
\keyword{correlation,}
\keyword{intermediate,}
\keyword{method}
