% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mparse.R
\name{C_code}
\alias{C_code}
\title{Extract the C code from a \code{SimInf_model} object}
\usage{
C_code(model, pkg = NULL)
}
\arguments{
\item{model}{The \code{SimInf_model} object to extract the C code
from.}

\item{pkg}{Character vector. If the C could should be used in a
package named \code{pkg}, the function modifies the C code to
facilitate adding the code to the package. Default is to not
use this argument and return the C code unmodified.}
}
\value{
Character vector with C code for the model.
}
\description{
Extract the C code from a \code{SimInf_model} object
}
\examples{
## Use the model parser to create a 'SimInf_model' object that
## expresses an SIR model, where 'b' is the transmission rate and
## 'g' is the recovery rate.
model <- mparse(transitions = c("S -> b*S*I/(S+I+R) -> I", "I -> g*I -> R"),
                compartments = c("S", "I", "R"),
                gdata = c(b = 0.16, g = 0.077),
                u0 = data.frame(S = 99, I = 1, R = 0),
                tspan = 1:10)

## View the C code.
C_code(model)

## Modify the C code for a package named "XYZ"
C_code(model, "XYZ")
}
