% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SISe.R
\name{SISe}
\alias{SISe}
\title{Create a SISe model}
\usage{
SISe(u0, tspan, events = NULL, phi = NULL, upsilon = NULL,
  gamma = NULL, alpha = NULL, beta_t1 = NULL, beta_t2 = NULL,
  beta_t3 = NULL, beta_t4 = NULL, end_t1 = NULL, end_t2 = NULL,
  end_t3 = NULL, end_t4 = NULL, epsilon = NULL)
}
\arguments{
\item{u0}{A \code{data.frame} with the initial state in each node
(see \sQuote{Details}).}

\item{tspan}{A vector (length >= 2) of increasing time points
where the state of each node is to be returned. Can be either
an \code{integer} or a \code{Date} vector. A \code{Date}
vector is coerced to a numeric vector as days, where
\code{tspan[1]} becomes the day of the year of the first year
of \code{tspan}. The dates are added as names to the numeric
vector.}

\item{events}{a \code{data.frame} with the scheduled events, see
\code{\link{SimInf_model}}.}

\item{phi}{A numeric vector with the initial environmental
infectious pressure in each node. Will be repeated to the
length of nrow(u0). Default is NULL which gives 0 in each
node.}

\item{upsilon}{Indirect transmission rate of the environmental
infectious pressure}

\item{gamma}{The recovery rate from infected to susceptible}

\item{alpha}{Shed rate from infected individuals}

\item{beta_t1}{The decay of the environmental infectious pressure
in interval 1.}

\item{beta_t2}{The decay of the environmental infectious pressure
in interval 2.}

\item{beta_t3}{The decay of the environmental infectious pressure
in interval 3.}

\item{beta_t4}{The decay of the environmental infectious pressure
in interval 4.}

\item{end_t1}{vector with the non-inclusive day of the year that
ends interval 1 in each node. Will be repeated to the length
of nrow(u0).}

\item{end_t2}{vector with the non-inclusive day of the year that
ends interval 2 in each node. Will be repeated to the length
of nrow(u0).}

\item{end_t3}{vector with the non-inclusive day of the year that
ends interval 3 in each node. Will be repeated to the length
of nrow(u0).}

\item{end_t4}{vector with the non-inclusive day of the year that
ends interval 4 in each node. Will be repeated to the length
of nrow(u0).}

\item{epsilon}{The background environmental infectious pressure}
}
\value{
\code{SISe}
}
\description{
Create a SISe model to be used by the simulation framework.
}
\details{
The argument \code{u0} must be a \code{data.frame} with one row for
each node with the following columns:
\describe{
\item{S}{The number of sucsceptible in each node}
\item{I}{The number of infected in each node}
}
}
\section{Beta}{

The time dependent beta is divided into four intervals of the year
\preformatted{
where 0 <= day < 365

Case 1: END_1 < END_2 < END_3 < END_4
INTERVAL_1 INTERVAL_2     INTERVAL_3     INTERVAL_4     INTERVAL_1
[0, END_1) [END_1, END_2) [END_2, END_3) [END_3, END_4) [END_4, 365)

Case 2: END_3 < END_4 < END_1 < END_2
INTERVAL_3 INTERVAL_4     INTERVAL_1     INTERVAL_2     INTERVAL_3
[0, END_3) [END_3, END_4) [END_4, END_1) [END_1, END_2) [END_2, 365)

Case 3: END_4 < END_1 < END_2 < END_3
INTERVAL_4 INTERVAL_1     INTERVAL_2     INTERVAL_3     INTERVAL_4
[0, END_4) [END_4, END_1) [END_1, END_2) [END_2, END_3) [END_3, 365)
}
}

