% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimInf_model.R
\name{V<-}
\alias{V<-}
\title{Set a template for where to write the V result matrix}
\usage{
V(model) <- value
}
\arguments{
\item{model}{The \code{model} to set a template for the result
matrix \code{V}.}

\item{value}{A \code{data.frame} that specify the nodes,
time-points and compartments of when to record the real-valued
continuous state at \code{tspan}. Use \code{NULL} to reset the
model to record the real-valued continuous state in every node
at each time-point in tspan.}
}
\description{
Using a sparse V result matrix can save a lot of memory if the
model contains many nodes and time-points, but where only a few of
the data points are of interest for post-processing.
}
\details{
Using a sparse V result matrix can save a lot of memory if the
model contains many nodes and time-points, but where only a few of
the data points are of interest for post-processing. To use this
feature, a template has to be defined for which data points to
record. This is done using a \code{data.frame} that specifies the
time-points (column \sQuote{time}) and nodes (column
\sQuote{node}) to record the state of the continuous state
compartments, see \sQuote{Examples}. The specified time-points,
nodes and compartments must exist in the model, or an error is
raised. Note that specifying a template only affects which
data-points are recorded for post-processing, it does not affect
how the solver simulates the trajectory.
}
\examples{
## Create an 'SISe' model with 6 nodes and initialize
## it to run over 10 days.
u0 <- data.frame(S = 100:105, I = 1:6)
model <- SISe(u0 = u0, tspan = 1:10, phi = rep(0, 6),
    upsilon = 0.02, gamma = 0.1, alpha = 1, epsilon = 1.1e-5,
    beta_t1 = 0.15, beta_t2 = 0.15, beta_t3 = 0.15, beta_t4 = 0.15,
    end_t1 = 91, end_t2 = 182, end_t3 = 273, end_t4 = 365)

## Run the model
result <- run(model, threads = 1)

## Display the continuous state variable 'phi' for every node at
## each time-point in tspan.
trajectory(result, compartments = "phi")

## Assume we are only interested in nodes '2' and '4' at the
## time-points '3' and '5'
df <- data.frame(time = c(3, 5, 3, 5),
                 node = c(2, 2, 4, 4),
                 phi = c(TRUE, TRUE, TRUE, TRUE))
V(model) <- df
result <- run(model, threads = 1)
trajectory(result, compartments = "phi")

## It is possible to use an empty 'data.frame' to specify
## that no data-points should be recorded for the trajectory.
V(model) <- data.frame()
result <- run(model, threads = 1)
trajectory(result, compartments = "phi")

## Use 'NULL' to reset the model to record data for every node at
## each time-point in tspan.
V(model) <- NULL
result <- run(model, threads = 1)
trajectory(result, compartments = "phi")
}
