% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/SISe.R, R/SISe3.R,
%   R/SISe3_sp.R, R/SISe_sp.R
\docType{methods}
\name{prevalence}
\alias{prevalence}
\alias{prevalence,SISe-method}
\alias{prevalence,SISe3-method}
\alias{prevalence,SISe3_sp-method}
\alias{prevalence,SISe_sp-method}
\title{Prevalence}
\usage{
prevalence(model, ...)

\S4method{prevalence}{SISe}(model, wnp = FALSE, i = NULL, by = 1, ...)

\S4method{prevalence}{SISe3}(model, age = 1:3, wnp = FALSE, i = NULL,
  by = 1, ...)

\S4method{prevalence}{SISe3_sp}(model, age = 1:3, wnp = FALSE, i = NULL,
  by = 1, ...)

\S4method{prevalence}{SISe_sp}(model, wnp = FALSE, i = NULL, by = 1, ...)
}
\arguments{
\item{model}{The \code{model} to calculated the prevalence from}

\item{...}{Additional arguments affecting the measure}

\item{wnp}{Determine within-node prevalence. Default is FALSE.}

\item{i}{Indices specifying the nodes to include in the
calculation of the prevalence. If \code{wnp = TRUE}, then
specifying which nodes to extract prevalence for. Default is NULL,
which includes all nodes.}

\item{by}{The number to increment the sequence of time points
starting from 1. Default is 1, which gives the prevalence at every
time point.}

\item{age}{For models with age categories, the age category to
include in the calculation. Default is that all age categories are
included.}
}
\description{
Calculate the proportion infected individuals
}
\examples{
## Create a 'SISe' demo model with 5 nodes and initialize
## it to run over 10 days.
model <- demo_model(nodes = 5, days = 10, model = "SISe")

## Run the model and save the result
result <- run(model)

## Extract the prevalence of infected nodes after each time
## step in the simulation
prevalence(result)

## Extract the prevalence of infected nodes after each time
## step in the simulation when including only the first,
## second and third node in the population at risk.
prevalence(result, i = 1:3)

## Extract the prevalence of infected nodes after every other
## time step in the simulation when including only the first,
## second and third node in the population at risk.
prevalence(result, i = 1:3, by = 2)

## Extract the within-node prevalence of infected individuals
## in each node after each time step in the simulation
prevalence(result, wnp = TRUE)

## Extract the within-node prevalence of infected individuals
## in the first and third node after each time step in the
## simulation
prevalence(result, wnp = TRUE, i = c(1, 3))

## Extract the within-node prevalence of infected individuals
## in the first and third node after every other time step in
## the simulation
prevalence(result, wnp = TRUE, i = c(1, 3), by = 2)

## Create a 'SISe3' demo model with 5 nodes and initialize
## it to run over 10 days.
model <- demo_model(nodes = 5, days = 10, model = "SISe3")

## Run the model and save the result
result <- run(model)

## Extract the prevalence of infected nodes after each time
## step in the simulation
prevalence(result)

## Extract the within-node prevalence of infected
## individuals in the third age category after each
## time step in the simulation
prevalence(result, wnp = TRUE, age = 3)
}
\keyword{methods}
