% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scheduled_events.R, R/siminf_model.R, R/SEIR.R, R/SIR.R, R/SISe.R, R/SISe3.R, R/SISe3_sp.R, R/SISe_sp.R
\docType{methods}
\name{plot,scheduled_events-method}
\alias{plot}
\alias{plot,SEIR-method}
\alias{plot,SIR-method}
\alias{plot,SISe-method}
\alias{plot,SISe3-method}
\alias{plot,SISe3_sp-method}
\alias{plot,SISe_sp-method}
\alias{plot,scheduled_events-method}
\alias{plot,siminf_model-method}
\alias{plot-methods}
\title{Plot \code{\linkS4class{siminf_model}}}
\usage{
\S4method{plot}{scheduled_events}(x, frame.plot = FALSE, ...)

\S4method{plot}{siminf_model}(x, legend, t0 = NULL, col = NULL,
  lty = NULL, ...)

\S4method{plot}{SEIR}(x, t0 = NULL, ...)

\S4method{plot}{SIR}(x, t0 = NULL, ...)

\S4method{plot}{SISe}(x, t0 = NULL, ...)

\S4method{plot}{SISe3}(x, t0 = NULL, ...)

\S4method{plot}{SISe3_sp}(x, t0 = NULL, ...)

\S4method{plot}{SISe_sp}(x, t0 = NULL, ...)
}
\arguments{
\item{x}{The \code{model} to plot}

\item{frame.plot}{Draw a frame around each plot. Default is FALSE.}

\item{...}{Additional arguments affecting the plot produced.}

\item{legend}{The character vector to appear in the legend.}

\item{t0}{The first date of \code{x@tspan} as a character string
in format 'yyyy-mm-dd'. Default is NULL which prints the x-axis
labels as the sequence 1:length(x@tspan). If non-null, the labels
are converted to dates.}

\item{col}{The plotting color for each compartment. Default is
black.}

\item{lty}{The line type for each compartment. Default is the
sequence: 1=solid, 2=dashed, 3=dotted, 4=dotdash, 5=longdash,
6=twodash.}
}
\description{
Plot \code{\linkS4class{siminf_model}}
}
\examples{
## Create a 'SISe' demo model with 1 node and initialize
## it to run over 1000 days.
model <- demo_model(nodes = 1, days = 1000, model = "SISe")

## Run the model and save the result
result <- run(model)

## Plot the proportion susceptible and infected individuals
plot(result)
}

