% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelGenerator.R
\name{ModelGenerator}
\alias{ModelGenerator}
\title{Generates an ensemble of neural network models.}
\usage{
ModelGenerator(
  R,
  N = 1,
  num.cores = 1,
  verbose = TRUE,
  hidden = 1,
  set.seed = TRUE,
  seed = "42"
)
}
\arguments{
\item{R}{Reference data set returned by \code{\link{GetTrainingData_HPCA}}}

\item{N}{Number of neural networks to train. Default is 1.}

\item{num.cores}{Number of cores to use for parallel computing. Default is 1.}

\item{verbose}{if TRUE, code will report outputs. Default is TRUE.}

\item{hidden}{Number of hidden layers in the neural network. Default is 1.}

\item{set.seed}{If TRUE, seed is set to ensure reproducibility of these results. Default is TRUE.}

\item{seed}{if set.seed is TRUE, the seed can be set. Default is 42.}
}
\value{
A list, each containing N neural network models
}
\description{
\code{\link{ModelGenerator}} generates an ensemble of neural network models
each trained to classify cellular phenotypes using the reference data set.
}
\examples{
\dontrun{
# download training data set from GitHub
Ref = GetTrainingData_HPCA()

# train a stack of 1,800 neural network models
Models = ModelGenerator(R = Ref, N = 100, num.cores = 4)

# save models
save(Models, file = "models.rda")
}
}
\seealso{
[SignacFast()] for a function that uses the models generated by this function.
}
