% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{SaveCountsToH5}
\alias{SaveCountsToH5}
\title{Save count_matrix.h5 files for SPRING integration}
\usage{
SaveCountsToH5(D, data.dir, genome = "GRCh38")
}
\arguments{
\item{D}{A list of count matrices}

\item{data.dir}{directory (will be created if it does not exist) where results are saved}

\item{genome}{default is GRCh38.}
}
\value{
matrix.h5 file, where each is background corrected
}
\description{
To integrate with SPRING, \code{SaveCountsToH5} saves expression matrices
in a sparse ".h5" format to be read with SPRING notebooks in Jupyter.
}
\examples{
\dontrun{
# download single cell data for classification
file.dir = "https://cf.10xgenomics.com/samples/cell-exp/3.0.0/pbmc_1k_v3/"
file = "pbmc_1k_v3_filtered_feature_bc_matrix.h5"
download.file(paste0(file.dir, file), "Ex.h5")

# load data
library(Seurat)
E = Read10X_h5(filename = "Ex.h5")

# save counts to h5 files
SaveCountsToH5(E, data.dir = "counts_h5")

}
}
