% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{GenerateLabels}
\alias{GenerateLabels}
\title{Generates cellular phenotype labels}
\usage{
GenerateLabels(
  cr,
  E = NULL,
  smooth = TRUE,
  new_populations = NULL,
  new_categories = NULL,
  min.cells = 10,
  spring.dir = NULL,
  graph.used = "nn"
)
}
\arguments{
\item{cr}{list returned by \code{\link{Signac}} or by \code{\link{SignacFast}}.}

\item{E}{a sparse gene (rows) by cell (column) matrix, or a Seurat object. Rows are HUGO symbols.}

\item{smooth}{if TRUE, smooths the cell type classifications. Default is TRUE.}

\item{new_populations}{Character vector specifying any new cell types that were learned by Signac. Default is NULL.}

\item{new_categories}{If new_populations are set to a cell type, new_category is a corresponding character vector indicating the population that the new population belongs to. Default is NULL.}

\item{min.cells}{If desired, any cell population with equal to or less than N cells is set to "Unclassified." Default is 10 cells.}

\item{spring.dir}{If using SPRING, directory to categorical_coloring_data.json. Default is NULL.}

\item{graph.used}{If using Seurat object by default, Signac uses the nearest neighbor graph in the graphs field of the Seurat object. Other options are "wnn" to use weighted nearest neighbors, as well as "snn" to use shared nearest neighbors.}
}
\value{
A list of cell type labels for cell types, cell states and novel populations.
}
\description{
\code{GenerateLabels} returns a list of cell type and cell state labels, as well as novel cellular phenotypes and unclassified cells.
}
\examples{
\dontrun{
# download single cell data for classification
file.dir = "https://cf.10xgenomics.com/samples/cell-exp/3.0.0/pbmc_1k_v3/"
file = "pbmc_1k_v3_filtered_feature_bc_matrix.h5"
download.file(paste0(file.dir, file), "Ex.h5")

# load data, process with Seurat
library(Seurat)
E = Read10X_h5(filename = "Ex.h5")
pbmc <- CreateSeuratObject(counts = E, project = "pbmc")

# run Seurat pipeline
pbmc <- SCTransform(pbmc, verbose = FALSE)
pbmc <- RunPCA(pbmc, verbose = FALSE)
pbmc <- FindNeighbors(pbmc, dims = 1:30, verbose = FALSE)

# classify cells
labels = SignacFast(E = pbmc)
celltypes = GenerateLabels(labels, E = pbmc)
}
}
