% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/targetselection.R
\name{targetselection}
\alias{targetselection}
\title{Target Matrix Selection}
\usage{
targetselection(data, centered = FALSE)
}
\arguments{
\item{data}{a numeric matrix containing the data.}

\item{centered}{a logical indicating if the mean vector is the zero vector.}
}
\value{
Prints the estimated optimal shrinkage intensities, the range and
average of the sample variances and returns an object of the class
'targetsel' that has components: \item{optimal_sphericity}{The estimated
optimal intensity for a target matrix with equal variances.}
\item{optimal_identity}{The estimated optimal shrinkage
intensity for the identity target matrix.} \item{optimal_diagonal}{The
estimated optimal intensity for a target matrix with unequal variances.}
\item{range}{The range of the sample variances.} \item{average}{The average
of the sample variances.}
}
\description{
Implements the rule of thumb proposed by Touloumis (2015) for target matrix
selection. If the estimated optimal shrinkage intensities of the three
target matrices are of similar magnitude, then the average and the range of
the sample variances should be inspected in order to adopt the most
plausible target matrix.
}
\details{
The rows of the data matrix \code{data} correspond to variables and the
columns to subjects.
}
\examples{
data(colon)
normal_group <- colon[, 1:40]
targetselection(normal_group)
## Similar intensities, the range of the sample variances is small and the
## average is not close to one. The scaled identity matrix seems to be the
## most suitable target matrix for the normal group.

tumor_group <- colon[, 41:62]
targetselection(tumor_group)
## Similar intensities, the range of the sample variances is small and the
## average is not close to one. The scaled identity matrix seems to be the
## most suitable target matrix for the colon group.
}
\references{
Touloumis, A. (2015) Nonparametric Stein-type Shrinkage
Covariance Matrix Estimators in High-Dimensional Settings.
\emph{Computational Statistics & Data Analysis} \bold{83}, 251--261.
}
\author{
Anestis Touloumis
}
