% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration.R
\name{MixingMetric}
\alias{MixingMetric}
\title{Calculates a mixing metric}
\usage{
MixingMetric(
  object,
  grouping.var,
  reduction = "pca",
  dims = 1:2,
  k = 5,
  max.k = 300,
  eps = 0,
  verbose = TRUE
)
}
\arguments{
\item{object}{Seurat object}

\item{grouping.var}{Grouping variable for dataset}

\item{reduction}{Which dimensionally reduced space to use}

\item{dims}{Dimensions to use}

\item{k}{Neighbor number to examine per group}

\item{max.k}{Maximum size of local neighborhood to compute}

\item{eps}{Error bound on the neighbor finding algorithm (from RANN)}

\item{verbose}{Displays progress bar}
}
\value{
Returns a vector of values of the mixing metric for each cell
}
\description{
Here we compute a measure of how well mixed a composite dataset is. To
compute, we first examine the local neighborhood for each cell (looking at
max.k neighbors) and determine for each group (could be the dataset after
integration) the k nearest neighbor and what rank that neighbor was in the
overall neighborhood. We then take the median across all groups as the mixing
metric per cell.
}
\concept{integration}
