% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{JackStrawPlot}
\alias{JackStrawPlot}
\title{JackStraw Plot}
\usage{
JackStrawPlot(object, dims = 1:5, reduction = "pca", xmax = 0.1, ymax = 0.3)
}
\arguments{
\item{object}{Seurat object}

\item{dims}{Dims to plot}

\item{reduction}{reduction to pull jackstraw info from}

\item{xmax}{X-axis maximum on each QQ plot.}

\item{ymax}{Y-axis maximum on each QQ plot.}
}
\value{
A ggplot object
}
\description{
Plots the results of the JackStraw analysis for PCA significance. For each
PC, plots a QQ-plot comparing the distribution of p-values for all genes
across each PC, compared with a uniform distribution. Also determines a
p-value for the overall significance of each PC (see Details).
}
\details{
Significant PCs should show a p-value distribution (black curve) that is
strongly skewed to the left compared to the null distribution (dashed line)
The p-value for each PC is based on a proportion test comparing the number
of genes with a p-value below a particular threshold (score.thresh), compared with the
proportion of genes expected under a uniform distribution of p-values.
}
\examples{
data("pbmc_small")
JackStrawPlot(object = pbmc_small)

}
\seealso{
\code{\link{ScoreJackStraw}}
}
\author{
Omri Wurtzel
}
\concept{visualization}
