% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{MetaFeature}
\alias{MetaFeature}
\title{Aggregate expression of multiple features into a single feature}
\usage{
MetaFeature(
  object,
  features,
  meta.name = "metafeature",
  cells = NULL,
  assay = NULL,
  slot = "data"
)
}
\arguments{
\item{object}{A Seurat object}

\item{features}{List of features to aggregate}

\item{meta.name}{Name of column in metadata to store metafeature}

\item{cells}{List of cells to use (default all cells)}

\item{assay}{Which assay to use}

\item{slot}{Which slot to take data from (default data)}
}
\value{
Returns a \code{Seurat} object with metafeature stored in objct metadata
}
\description{
Calculates relative contribution of each feature to each cell
for given set of features.
}
\examples{
pbmc_small <- MetaFeature(
  object = pbmc_small,
  features = c("LTB", "EAF2"),
  meta.name = 'var.aggregate'
)
head(pbmc_small[[]])

}
