% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{DimPlot}
\alias{DimPlot}
\title{Dimensional reduction plot}
\usage{
DimPlot(object, reduction.use = "pca", dim.1 = 1, dim.2 = 2,
  cells.use = NULL, pt.size = 1, do.return = FALSE, do.bare = FALSE,
  cols.use = NULL, group.by = "ident", pt.shape = NULL,
  do.hover = FALSE, data.hover = "ident", do.identify = FALSE,
  do.label = FALSE, label.size = 4, no.legend = FALSE,
  coord.fixed = FALSE, no.axes = FALSE, dark.theme = FALSE,
  plot.order = NULL, cells.highlight = NULL, cols.highlight = "red",
  sizes.highlight = 1, plot.title = NULL, vector.friendly = FALSE,
  png.file = NULL, png.arguments = c(10, 10, 100), ...)
}
\arguments{
\item{object}{Seurat object}

\item{reduction.use}{Which dimensionality reduction to use. Default is
"pca", can also be "tsne", or "ica", assuming these are precomputed.}

\item{dim.1}{Dimension for x-axis (default 1)}

\item{dim.2}{Dimension for y-axis (default 2)}

\item{cells.use}{Vector of cells to plot (default is all cells)}

\item{pt.size}{Adjust point size for plotting}

\item{do.return}{Return a ggplot2 object (default : FALSE)}

\item{do.bare}{Do only minimal formatting (default : FALSE)}

\item{cols.use}{Vector of colors, each color corresponds to an identity
class. By default, ggplot assigns colors.}

\item{group.by}{Group (color) cells in different ways (for example, orig.ident)}

\item{pt.shape}{If NULL, all points are circles (default). You can specify any
cell attribute (that can be pulled with FetchData) allowing for both different colors and
different shapes on cells.}

\item{do.hover}{Enable hovering over points to view information}

\item{data.hover}{Data to add to the hover, pass a character vector of features to add. Defaults to cell name and ident. Pass 'NULL' to clear extra information.}

\item{do.identify}{Opens a locator session to identify clusters of cells.}

\item{do.label}{Whether to label the clusters}

\item{label.size}{Sets size of labels}

\item{no.legend}{Setting to TRUE will remove the legend}

\item{coord.fixed}{Use a fixed scale coordinate system (for spatial coordinates). Default is FALSE.}

\item{no.axes}{Setting to TRUE will remove the axes}

\item{dark.theme}{Use a dark theme for the plot}

\item{plot.order}{Specify the order of plotting for the idents. This can be
useful for crowded plots if points of interest are being buried. Provide
either a full list of valid idents or a subset to be plotted last (on top).}

\item{cells.highlight}{A list of character or numeric vectors of cells to highlight. If only one group of cells desired, can simply
pass a vector instead of a list. If set, colors selected cells to the color(s) in \code{cols.highlight} and other cells black
(white if dark.theme = TRUE); will also resize to the size(s) passed to \code{sizes.highlight}}

\item{cols.highlight}{A vector of colors to highlight the cells as; will repeat to the length groups in cells.highlight}

\item{sizes.highlight}{Size of highlighted cells; will repeat to the length groups in cells.highlight}

\item{plot.title}{Title for plot}

\item{vector.friendly}{FALSE by default. If TRUE, points are flattened into a PNG, while axes/labels retain full vector resolution. Useful for producing AI-friendly plots with large numbers of cells.}

\item{png.file}{Used only if vector.friendly is TRUE. Location for temporary PNG file.}

\item{png.arguments}{Used only if vector.friendly is TRUE. Vector of three elements
(PNG width, PNG height, PNG DPI) to be used for temporary PNG. Default is c(10,10,100)}

\item{...}{Extra parameters to FeatureLocator for do.identify = TRUE}
}
\value{
If do.return==TRUE, returns a ggplot2 object. Otherwise, only
graphical output.
}
\description{
Graphs the output of a dimensional reduction technique (PCA by default).
Cells are colored by their identity class.
}
\examples{
DimPlot(object = pbmc_small)

}
\seealso{
\code{FeatureLocator}
}
