% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial.R
\name{FitGeneK}
\alias{FitGeneK}
\title{Build mixture models of gene expression}
\usage{
FitGeneK(object, gene, do.k = 2, num.iter = 1, do.plot = FALSE,
  genes.use = NULL, start.pct = NULL)
}
\arguments{
\item{object}{Seurat object}

\item{gene}{Gene to fit}

\item{do.k}{Number of modes for the mixture model (default is 2)}

\item{num.iter}{Number of 'greedy k-means' iterations (default is 1)}

\item{do.plot}{Plot mixture model results}

\item{genes.use}{Genes to use in the greedy k-means step (See manuscript for details)}

\item{start.pct}{Initial estimates of the percentage of cells in the 'on'
state (usually estimated from the in situ map)}
}
\value{
A Seurat object, where the posterior of each cell being in the 'on'
or 'off' state for each gene is stored in object@spatial@mix.probs
}
\description{
Models the imputed gene expression values as a mixture of gaussian
distributions. For a two-state model, estimates the probability that a given
cell is in the 'on' or 'off' state for any gene. Followed by a greedy
k-means step where cells are allowed to flip states based on the overall
structure of the data (see Manuscript for details)
}
\examples{
\dontrun{
# Note that the PBMC test example object does not contain spatially restricted
# examples below are only demonstrate code
pmbc_small <- FitGeneK(object = pbmc_small, gene = "MS4A1")
}

}
