% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_modal.R
\name{SetAssayData}
\alias{SetAssayData}
\title{Assay Data Mutator Function}
\usage{
SetAssayData(object, assay.type, slot, new.data)
}
\arguments{
\item{object}{Seurat object}

\item{assay.type}{Type of assay to fetch data for (default is RNA)}

\item{slot}{Specific information to pull (i.e. raw.data, data, scale.data,...). Default is data}

\item{new.data}{New data to insert}
}
\value{
Seurat object with updated slot
}
\description{
Store information for specified assay, for multimodal analysis. new.data 
needs to have cells as the columns and measurement features (e.g. genes, 
proteins, etc ...) as rows. Additionally, all the cell names in the new.data
must match the cell names in the object (object@cell.names).
}
\examples{
# Simulate CITE-Seq results
df <- t(x = data.frame(
  x = round(x = rnorm(n = 80, mean = 20, sd = 2)),
  y = round(x = rbinom(n = 80, size = 100, prob = 0.2))
))
pbmc_small = SetAssayData(
  object = pbmc_small,
  assay.type = 'CITE',
  new.data = df,
  slot = 'raw.data'
)

}
