% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensional_reduction_utilities.R
\name{PCALoad}
\alias{PCALoad}
\title{PCA Gene Loadings Accessor Function}
\usage{
PCALoad(object, dims.use = NULL, genes.use = NULL, use.full = FALSE)
}
\arguments{
\item{object}{Seurat object}

\item{dims.use}{Dimensions to include (default is all stored dims)}

\item{genes.use}{Genes to include (default is all genes)}

\item{use.full}{Return projected gene loadings (default is FALSE)}
}
\value{
PCA gene loading matrix for given genes and PCs
}
\description{
Pull the PCA gene loadings matrix
}
\examples{
pbmc_small
head(PCALoad(pbmc_small))
# Optionally, you can specify subsets of dims or genes to use
PCALoad(pbmc_small, dims.use = 1:5, genes.use = pbmc_small@var.genes[1:5])

}
