% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StackingEnergy.R
\name{SequenceAnalysis.StackingEnergy}
\alias{SequenceAnalysis.StackingEnergy}
\title{SequenceAnalysis.StackingEnergy}
\usage{
SequenceAnalysis.StackingEnergy(Nucleotide_Sequence = NULL,
  UniprotKB = NULL, CDS = FALSE)
}
\arguments{
\item{Nucleotide_Sequence}{Nucleotide Sequence}

\item{UniprotKB}{UniProt ID of desired sequence}

\item{CDS}{if TRUE Stacking Energy of CDS Region will be calculated}
}
\value{
StackingEnergy
}
\description{
Stacking Energy obtained by NN model
}
\details{
The NN model for nucleic acids assumes that the stability of a given base pair depends on the identity and orientation of neighboring base pairs. Stacking Energy = DeltaG(total) = Sigma (n(i)*DeltaG(i)) + DeltaG(init) + DeltaG(end) + DeltaG(sym), which DeltaG for i, init and end is obtained by Unified NN free energy parameter. Symmetry of self-complementary duplexes is also included by DeltaG(sym) equals to +0.43 kcal/mol if the duplex is self-complementary and zero if it is non-self-complementary.
}
\examples{
SequenceAnalysis.StackingEnergy("actagtcacgatcag")
SequenceAnalysis.StackingEnergy(UniprotKB="O15131")
SequenceAnalysis.StackingEnergy(UniprotKB="O15131",CDS=TRUE)
}
\author{
Babak Khorsand
}

