\name{HSC_PP}
\alias{HSC_PP}
\title{Pre-processor top-level class}
\usage{
HSC_PP(fields, timestamp_field, create_unique_key = FALSE,
  auto_id = FALSE)
}
\arguments{
\item{fields}{(vector) - The complete list of fields in the input data streams that needs to be present in the output event stream}

\item{timestamp_field}{(character) - The name of the sequencing field. Could be autogenerated by the pre-processor, or already present in the input data streams. Used for ordering of the output event stream.}

\item{create_unique_key}{(logical) - If TRUE, the pre-processor adds field named \emph{.key} to the output event stream comprising a unique key (1) for all data items.}

\item{auto_id}{(logical) - If TRUE, the pre-processor generates autoincremented values and assigns then to the \emph{timestamp_field}. Can be used when input data streams do not comprise any timing information.}
}
\description{
Class that needs to be derived to create new pre-processors. A pre-processor can be directly instantiated from the HSC_PP class.
}
\details{
\strong{Example 1}\cr
\code{pp <- HSC_PP(c("product","time","sales"),"time")} - Creates a new HSC_PP pre-processor that uses \emph{time} field for ordering of the output event stream.\cr

\strong{Example 2}\cr
\code{pp <- HSC_PP(c("product","sales"),"sequence_id",auto_id=TRUE)} - Creates a new HSC_PP pre-processor that has no time field. Instead, the pre-processor adds the \emph{sequence_id} field and generates autoincremented values for it.\cr

\strong{Example 3}\cr
\code{pp <- HSC_PP(c("sequence_val"),"sequence_id",create_unique_key=TRUE,auto_id=TRUE)} - Creates a new HSC_PP pre-processor that has no time and no key field. The pre-processor adds the \emph{sequence_id} field and generates autoincremented values for it. Also, the \emph{.key=1} column is added to all output events.\cr
}
