% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyzeSentiment.R
\name{convertToBinaryResponse}
\alias{convertToBinaryResponse}
\title{Convert continuous sentiment to direction}
\usage{
convertToBinaryResponse(sentiment)
}
\arguments{
\item{sentiment}{Vector, matrix or data.frame with sentiment scores.}
}
\value{
If a vector is supplied, it returns a factor with two levels representing 
positive and negative content. Otherwise, it returns a data.frame with the 
corresponding columns being exchanged.
}
\description{
This function converts continuous sentiment scores into a their corresponding
binary sentiment class. As such, the result is a factor with two levels 
indicating positive and negative content. Neutral documents (with a sentiment
score of 0) are counted as positive.
}
\details{
If a matrix or data.frame is provided, this routine does not touch
all columns. In fact, it scans for those where the column name starts with
"Sentiment" and changes these columns only. Hence, columns with pure 
negativity, positivity or ratios or word counts are ignored.
}
\examples{
sentiment <- c(-1, -0.5, +1, 0.6, 0)
convertToBinaryResponse(sentiment)
convertToDirection(sentiment)

df <- data.frame(No=1:5, Sentiment=sentiment)
df
convertToBinaryResponse(df)
convertToDirection(df)
}
\seealso{
\code{\link{convertToDirection}}
}
\keyword{evaluation}
\keyword{sentiment}
