% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyzeSentiment.R
\name{compareToResponse}
\alias{compareToResponse}
\alias{compareToResponse.logical}
\alias{compareToResponse.factor}
\alias{compareToResponse.integer}
\alias{compareToResponse.data.frame}
\alias{compareToResponse.numeric}
\title{Compare sentiment values to existing response variable}
\usage{
compareToResponse(sentiment, response)

\method{compareToResponse}{logical}(sentiment, response)

\method{compareToResponse}{factor}(sentiment, response)

\method{compareToResponse}{integer}(sentiment, response)

\method{compareToResponse}{data.frame}(sentiment, response)

\method{compareToResponse}{numeric}(sentiment, response)
}
\arguments{
\item{sentiment}{Matrix with sentiment scores for each document across several 
sentiment rules}

\item{response}{Vector with "true" response. This vector can either be of a 
continuous numeric or binary values. In case of the latter, FALSE is matched 
to a negative sentiment value, while TRUE is matched to a non-negative one.}
}
\value{
Matrix with different performance metrics for all given sentiment 
rules
}
\description{
This function compares the calculated sentiment values with an external
response variable. Examples of such an exogenous response are stock market
movements or IMDb move rating. Both usually reflect a "true" value that 
the sentiment should match.
}
\examples{
sentiment <- matrix(c(5.5, 2.9, 0.9, -1), 
                    dimnames=list(c("A", "B", "C", "D"), c("Sentiment")))

# continuous numeric response variable
response <- c(5, 3, 1, -1)
compareToResponse(sentiment, response)

# binary response variable
response <- c(TRUE, TRUE, FALSE, FALSE)
compareToResponse(sentiment, response)
}
\keyword{evaluation}
