\name{ham}
\alias{ham}
\title{
 Conjoint study of dry cured ham
}
\description{
 One of the purposes of the study was to investigate the effect of information given to the consumers measured in hedonic liking for the hams. Two of the hams were Spanish and two were Norwegian, each origin representing different salt levels and different aging time. The information about origin was given in such way that both true and false information was given. essentially a 4*2 design with 4 samples and 2 information levels. A total of 81 Consumers participated in the study.    
}
\usage{
ham
}
\format{
\describe{
  \item{\code{Consumer}}{
    factor with 81 levels: numbering identifying consumers
  }
  \item{\code{Product}}{
   factor with four levels
  }
  \item{\code{Informed.liking}}{
    numeric: hedonic liking for the products
  }
  \item{\code{Information}}{
    factor with two levels
  }
  \item{\code{Gender}}{
    factor with two levels (gender)
  }
  \item{\code{Age}}{
    numeric: age of Consumer
  } 
}}

\references{
 "Alternative methods for combining design variables and consumer preference with information about attitudes and demographics in conjoint analysis" . T. Naes, V.Lengard, S. Bolling Johansen, M. Hersleth
}


\keyword{datasets}


\examples{
## check with the  ham
response <- c("Liking")
fixed <- list(Product=c("Product", "Information"), Consumer="Gender")
random <- c("Consumer")
facs <- c("Consumer", "Product", "Information", "Gender")

res.ham <- conjoint(structure=1, ham, response, fixed, random, facs)
}