% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcori_control.R
\name{pcori_control}
\alias{pcori_control}
\title{Control Parameters for Fitting the within Group Model}
\usage{
pcori_control(
  integration.method = c("quadvcpp", "quadv", "linear", "numerical", "piecewise"),
  intensity.bandwidth = NULL,
  resolution = 1000,
  resolution.within.period = 50,
  tol = .Machine$double.eps^(1/4),
  ...
)
}
\arguments{
\item{integration.method}{Method for integration when computing the second influence term.}

\item{intensity.bandwidth}{The bandwidth for the intensity model.}

\item{resolution}{The number of points to use for numerical integration.}

\item{resolution.within.period}{The number of points to use for numerical integration within a period.}

\item{tol}{The tolerance for numerical integration.}

\item{...}{Currently ignored.}
}
\value{
a list of control parameters.
}
\description{
Control Parameters for Fitting the within Group Model
}
\keyword{internal}
