% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find.dictionaries.R
\name{find.dictionaries}
\alias{find.dictionaries}
\title{Finds Names and Locations of Appendix Dictionaries}
\usage{
find.dictionaries(...)
}
\arguments{
\item{...}{Vector.
Appendix dictionary files names (if they are known).
If left empty, the function will search across
all files for files in folders on your desktop
that end in \code{*.dictionary.rds}.
This search takes a few seconds to complete
(see examples for your computer's exact timing)}
}
\value{
\item{names}{Returns the names of the appendix dictionary file(s) found on your computer}

\item{files}{Returns the dictionary file(s) that are stored in each given path. If there is no output
(e.g., \code{character(0)}), then no appendix dictionary file exists
(one can be created using the \code{\link[SemNetDictionaries]{append.dictionary}} function)}
}
\description{
A wrapper function to identify the save location
of appendix dictionaries from \code{\link[SemNetDictionaries]{append.dictionary}}
}
\examples{
# Make a dictionary
example.dictionary <- append.dictionary(c("words","are","fun"), save.location = "envir")
 
# Dictionary can now be found
find.dictionaries("example")
\donttest{
# No appendix dictionaries found
find.dictionaries()

# For your computer's timing to complete search
t0 <- Sys.time()
find.dictionaries()
Sys.time() - t0
}

}
\seealso{
\code{\link{append.dictionary}} to create a new dictionary,
\code{\link{dictionaries}} to identify dictionaries in
\code{\link{SemNetDictionaries}}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
