% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equate.R
\name{equate}
\alias{equate}
\title{Equate Groups}
\usage{
equate(...)
}
\arguments{
\item{...}{Matrices, data frames or a list of matrices and data frames.
Binary response matrices to be equated}
}
\value{
This function returns a list containing the
equated binary response matrices in the order they were input.
The response matrices are labeled as the object name they were
entered with
}
\description{
A function to "equate" multiple response matrices to one another.
\emph{N} number of groups are matched based on their responses so
that every group has the same responses in their data
}
\examples{
# Obtain binary data
bin <- open.binary

# Finalize mat1
mat1 <- finalize(bin[c(1:5),])

# Finalize mat2
mat2 <- finalize(bin[c(6:10),])

# Equate mat1 and mat1
eq <- equate(mat1, mat2)

# Obtain respective equated response matrices
eq.mat1 <- eq$mat1 # list objects are named with the names
eq.mat2 <- eq$mat2 # they were entered with

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
