% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_deseq.R
\name{filter_deseq}
\alias{filter_deseq}
\title{Filter DESEQ2 Results for SeedMatchR}
\usage{
filter_deseq(
  res,
  fdr.cutoff = 1,
  fc.cutoff = 0,
  rm.na.name = FALSE,
  rm.na.log2fc = FALSE,
  baseMean.cutoff = 0
)
}
\arguments{
\item{res}{The DESEQ2 results as a data frame}

\item{fdr.cutoff}{The false discovery rate cutoff to use.}

\item{fc.cutoff}{The fold change cutoff to use. The absolute
value will be used as the cutoff and values greater-than-or-equal-to will
be kept.}

\item{rm.na.name}{Remove na values from the gene_name column}

\item{rm.na.log2fc}{Remove na values from the log2FoldChange column}

\item{baseMean.cutoff}{The minimum baseMean expression cutoff}
}
\value{
A modified DESEQ2 results table that has been filtered
}
\description{
Filter \code{DESeqDataSet} results for use with seed matching
and counting functions.

The filtering criteria are:

Filter out genes that are not expressed or counted at all:
baseMean = 0 & pvalue = NA & log2FoldChange = NA

Filter out genes that are expressed, but there is not difference across
groups: log2FoldChange = 0

Filter out genes with extreme outliers: pvalue = NA and padj = NA

Filter out genes that have been excluded by independent filtering. padj = NA

Filter results by the \code{fdr.cutoff}

Filter the results by the \code{log2FoldChange}

Filter the results by the \code{baseMean}

Remove NA gene_ids and log2FoldChange values
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Load test data
get_example_data("sirna")

sirna.data = load_example_data("sirna")

res <- sirna.data$Schlegel_2022_Ttr_D1_30mkg

# Filter DESeq2 results for SeedMatchR
res = filter_deseq(res, fdr.cutoff=1, fc.cutoff=0, rm.na.log2fc = TRUE)
\dontshow{\}) # examplesIf}
}
