% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecdf_stat_test.R
\name{ecdf_stat_test}
\alias{ecdf_stat_test}
\title{Test for differences in log2(Fold Change) ECDFs between two gene lists using
the \code{twosamples} package}
\usage{
ecdf_stat_test(
  res,
  gene.list1,
  gene.list2,
  stats.test = "KS",
  nboots = 10000,
  keep.boots = TRUE
)
}
\arguments{
\item{res}{Input results file data frame}

\item{gene.list1}{Gene list 1: Usually null distribution}

\item{gene.list2}{Gene list 2: Target set of genes}

\item{stats.test}{Stats test to use. Options: KS, Kuiper, DTS, CVM, AD, Wass}

\item{nboots}{Number of bootstraps to use for generating a null}

\item{keep.boots}{Whether to store the boostrap values}
}
\value{
A vector containing the dstat and pvalue
}
\description{
This function uses the \code{twosamples} package to test the ECDF
of log2(Fold Changes) between two groups based on DESeq2 analysis.

The inputs of this function are a DESeq2 results \code{data.frame} and two sets of
gene IDs called \code{gene.list1} and \code{gene.list2}. The functions will look for a
column called \code{log2FoldChange} in the dataframe.

The user can choose 1 of 6 tests for comparing the ECDFs of two gene sets.
Options: \code{KS}, \code{Kuiper}, \code{DTS}, \code{CVM}, \code{AD}, \code{Wass}
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(dplyr)

guide.seq = "UUAUAGAGCAAGAACACUGUUUU"

anno.db = load_species_anno_db("human")

features = get_feature_seqs(anno.db$tx.db, anno.db$dna)

# Load test data
get_example_data("sirna")

sirna.data = load_example_data("sirna")

res <- sirna.data$Schlegel_2022_Ttr_D1_30mkg

# Filter DESeq2 results for SeedMatchR
res = filter_deseq(res, fdr.cutoff=1, fc.cutoff=0, rm.na.log2fc = TRUE)

res = SeedMatchR(res, anno.db$gtf, features$seqs, guide.seq, "mer7m8")

# Gene set 1
mer7m8.list = res$gene_id[res$mer7m8 >= 1]

# Gene set 2
background.list = res$gene_id[!(res$mer7m8 \%in\% mer7m8.list)]

ecdf.res = ecdf_stat_test(res, mer7m8.list, background.list)
\dontshow{\}) # examplesIf}
}
