% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsdvar.R
\name{gsdvar}
\alias{gsdvar}
\title{Generating second-dimension variables for a spatial variable}
\usage{
gsdvar(
  pointlocation,
  gridlocation,
  gridvar,
  distbuf = seq(1, 10, 1),
  quantileprob = seq(0, 1, 0.1)
)
}
\arguments{
\item{pointlocation}{A matrix or data frame of point locations}

\item{gridlocation}{A matrix or data frame of grid locations}

\item{gridvar}{A matrix or data frame of grid variables}

\item{distbuf}{A vector of distance buffer values}

\item{quantileprob}{A vector of quantile probability values}
}
\value{
A data frame containing the selected variables for the second dimension
}
\description{
Generating second-dimension variables for a spatial variable
}
\examples{
data(obs)
data(grids)
pointlocation <- obs[sample(nrow(obs), 20), c("Lon", "Lat")]
gridlocation <- grids[, c("Lon", "Lat")]
gridvar <- grids$Elevation
system.time({
sdavars <- gsdvar(pointlocation, gridlocation, gridvar,
                  distbuf = c(1, 2, 3), quantileprob = c(0, 0.5, 1))
})

}
