% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Themes.R
\encoding{UTF-8}
\name{theme_pub}
\alias{theme_pub}
\title{The Default Theme}
\usage{
theme_pub(legend = "bottom", base_size = 12, base_family = "",
  horizontal = FALSE, axis_line = FALSE)
}
\arguments{
\item{legend}{enables to set legend position, default is "bottom".}

\item{base_size}{overall font size. Default is 14.}

\item{base_family}{a name for default font family.}

\item{horizontal}{logical. Horizontal axis lines?}

\item{axis_line}{enables to set x and y axes.}
}
\value{
The theme.
}
\description{
After loading the SciencesPo package, this theme will be
set to default for all subsequent graphs made with ggplot2.
}
\examples{
Previewplot() + theme_pub()

# Anscombe data
dat <- data.frame()
for(i in 1:4)
dat <- rbind(dat, data.frame(set=i, x=anscombe[,i], y=anscombe[,i+4]))

 gg <- ggplot(dat, aes(x, y))
gg <- gg + geom_point(size=5, color="red", fill="orange", shape=21)
gg <- gg + geom_smooth(method="lm", fill=NA, fullrange=TRUE)
gg <- gg + facet_wrap(~set, ncol=2)
gg <- gg + theme_pub(base_family=SciencesPoFont())
gg <- gg + theme(plot.background=element_rect(fill="#f7f7f7"))
gg <- gg + theme(panel.background=element_rect(fill="#f7f7f7"))

}
\author{
\Sexpr[stage=build,results=rd]{tools:::Rd_package_author("SciencesPo")}
}
\seealso{
\code{\link[ggplot2]{theme}}, \code{\link{theme_538}}, \code{\link{theme_blank}}.
}
\keyword{ggplot2}

