% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/untable.R
\encoding{UTF-8}
\name{untable}
\alias{untable}
\alias{untable.data.frame}
\alias{untable.default}
\title{Untable}
\usage{
untable(x, ...)

\method{untable}{data.frame}(x, freq = "Freq", rownames = NULL, ...)

\method{untable}{default}(x, dimnames = NULL, type = NULL,
  rownames = NULL, colnames = NULL, ...)
}
\arguments{
\item{x}{The table object as a data.frame, table, or, matrix.}

\item{freq}{The column with count values.}

\item{rownames}{Row names to add to the data.frame.}

\item{dimnames}{Set dimnames of an object if require.}

\item{type}{The type of variable. If NULL, ordered factor is returned.}

\item{colnames}{Column names to add to the data.frame.}

\item{\dots}{Extra parameters.}
}
\description{
Method for recreate the data.frame out of a contingency table, i.e., converts from summarized data to long.
}
\examples{
if (interactive()) {
gss <- data.frame(
expand.grid(sex=c("female", "male"),
party=c("dem", "indep", "rep")),
count=c(279,165,73,47,225,191))

print(gss)

# Then expand it:
GSS <- untable(gss, freq="count")
head(GSS)
}
}

