% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fillin.R
\name{fillin}
\alias{fillin}
\title{Filling in missing values
\code{fillin} replaces missing values with existing observations from other variable or data frame.}
\usage{
fillin(x, y, x.var, y.var = NULL, key)
}
\arguments{
\item{x}{the data frame with the variable you would like to fill in.}

\item{y}{the data frame with the variable you would like to use to fill in \code{x}.}

\item{x.var}{a character string of the name of the variable in \code{x} you want to fill in.}

\item{y.var}{an optional character string of variable name in \code{y} that you would like to use to fill in.}

\item{key}{a character vector of variable names that are shared by \code{x} and \code{y} that can be used to join the data frames.}
}
\description{
Filling in missing values
\code{fillin} replaces missing values with existing observations from other variable or data frame.
}
\examples{
# Create data set with missing values
data1 <- data.frame(a = sample(c(1,2), 100, rep=TRUE),
                    b = sample(c(3,4), 100, rep=TRUE),
                   fNA = sample(c(100, 200, 300, 400, NA), 100, rep=TRUE))

# Created full data set
data2 <- data.frame(a = c(1,2,1,2),
                     b = c(3,3,4,4),
                     full = c(100, 200, 300, 400))

# Fill in missings from data1 with values from data2
Filled <- fillin(data1, data2, x.var = "fNA", y.var = "full", key = c("a", "b"))
}
\keyword{Missings}

