% Generated by roxygen2 (4.0.2): do not edit by hand
\encoding{UTF-8}
\name{se}
\alias{se}
\alias{std.error}
\title{Calculate the Standard Error}
\usage{
se(x, na.rm = TRUE)
}
\arguments{
\item{x}{A vector of class numeric or integer}

\item{na.rm}{a logical value for \code{na.rm}, default is \code{na.rm=TRUE}.}
}
\description{
Compute the standard errors of a numeric vector
}
\details{
The standard error of the mean (SEM) (\emph{assuming statistical independence of the values in the sample}) is estimated by taking the standard deviation of the population sample, divided by the square root of the sample size: \deqn{se = \frac{{s}}{{\sqrt{n}}}}
}
\examples{
x <- rnorm(100);
se(x)
}
\author{
Daniel Marcelino, \email{dmarcelino@live.com}
}
\references{
Kenney, J. F. and Keeping, E. S. (1951) Standard Error of the Mean. In \emph{Mathematics of Statistics,} Pt. 2, 2nd ed. Princeton, NJ: Van Nostrand, pp. 110 and 132--133.
}

