% Generated by roxygen2 (4.0.2): do not edit by hand
\name{perc.table}
\alias{perc.table}
\title{Express table entries as percentage of marginal table.}
\usage{
perc.table(x, margin = NULL, digits = getOption("digits"), margins = TRUE)
}
\arguments{
\item{x}{A frequency table likely constructed with table().}

\item{margin}{A numeric representing an index, or vector of indices, to
generate the margin for -- \code{margin=1} computes row percentages,
\code{margin=2} computes column percentages, and \code{margin=NULL} (default)
produces table percentages.}

\item{digits}{A numeric indicating the number of decimals to round the
percentages to..}

\item{margins}{A logical indicating whether marginal totals should be
appended to the table or not.  If \code{addMargins=TRUE} then the appended
marginal totals will correspond to which margin is chosen with
\code{margin=}.}
}
\value{
Same type as \code{x} except with percentages of a margin rather than
frequencies.
}
\description{
Same as \code{prop.table()} except that it returns percentages rather than
proportions.
}
\examples{
Aye <- sample(c("Yes", "Si", "Oui"), 177, replace = TRUE)
Bee <- sample(c("Hum", "Buzz"), 177, replace = TRUE)
( A <- table(Aye, Bee) )

## what prop.table() would look like
prop.table(A,margin=1)

## modified for percTable
# row percentages
perc.table(A,margin=1)
perc.table(A,margin=1,digits=1)
# column percentages
perc.table(A,margin=2)
# table percentages
perc.table(A)

## No marginal totals
perc.table(A,margins=FALSE)
}
\keyword{manip}

