% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SILO.R
\name{SILOSiteSummary}
\alias{SILOSiteSummary}
\title{Produce a table summarising  SILO sites}
\usage{
SILOSiteSummary(SILO)
}
\arguments{
\item{SILO}{a list of sites with SILO data, as created by SILOLoad()}
}
\value{
a dataframe with the following columns
\describe{
\item{Site}{site name}
\item{Station}{station number}
\item{StartDate}{date of the first good quality rainfall data}
\item{EndDate}{date of the last good quality rainfall data}
\item{PctMissing}{percentage of days that do not have good quality code between StartDate and EndDate}
\item{AnnualRainfall}{Mean annual rainfall in mm}
\item{Latitute}{Latitude}
\item{Longitude}{Longitude}
\item{Elevation}{Elevation}
}
}
\description{
Produce a table summarising  SILO sites
}
\examples{
\dontrun{
X<-SILOLoad(c("24001","24002","24003"),path="./SWTools/extdata")
d<-SILOSiteSummary(X)
}

}
