% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SILOFindSitesByShapefile.R
\name{SILOSitesfromPolygon}
\alias{SILOSitesfromPolygon}
\title{Find SILO sites within a polygon}
\usage{
SILOSitesfromPolygon(shpFile, ssl = FALSE)
}
\arguments{
\item{shpFile}{location to a shapefile to search within for SILO sites}

\item{ssl}{See SILODownload, if true if true sets ssl_cipher_list="RC4-SHA" for httr::GET()}
}
\value{
a table of site information including site numbers found within the polygon
}
\description{
Find SILO sites within a polygon
}
\examples{
\dontrun{
Sites=SILOSitesfromPolygon("path/to/shapefile.shp")
SILODownload(Sites$Number,
path=tempdir(),
startdate="20180101",enddate="20200101")
X<-SILOLoad(Sites$Number,path=tempdir())
}
}
