#' Detailed NERRS site data
#'
#' Metadata on NERRS stations provided by the Central Data Management Office (CDMO) when data is downloaded
#'
#' @format A \code{\link[base]{data.frame}} object
#'
#' @references NOAA National Estuarine Research Reserve System (NERRS). System-wide Monitoring Program. Data accessed from the NOAA NERRS Centralized Data Management Office website: https://www.nerrsdata.org/; accessed 08 October 2016
#'
#' @docType data
#' @keywords datasets
#' @name sampling_stations
#' @usage data(sampling_stations)
#' @source \href{https://cdmo.baruch.sc.edu/}{CDMO}
#'

"sampling_stations"
